<?php
	$dir_map_api=get_option('_dir_map_api');
?>
<script type='text/javascript' src='https://maps.googleapis.com/maps/api/js?libraries=places&key=<?php echo esc_html($dir_map_api);?>'></script>
<div class="profile-content">
	<span class="caption-subject"> <?php esc_html_e('New Listing','ivdirectories'); ?></span>
	<hr>
	<div class="portlet-body">
		<?php
			global $wpdb;
			// Check Max\
			$package_id=get_user_meta($current_user->ID,'iv_directories_package_id',true);
			$max=get_post_meta($package_id, 'iv_directories_package_max_post_no', true);
			if($max==""){
				$user_role= $current_user->roles[0];
				if(isset($current_user->roles[0]) and $current_user->roles[0]=='administrator'){
					$max=999999;
				}
			}
			$sql="SELECT * FROM $wpdb->posts WHERE post_type = 'iv_directories_pack'  and post_status='draft' ";
			$membership_pack = $wpdb->get_results($sql);
			$total_package = count($membership_pack);
			if(count($membership_pack)<1){
				$max=999999;
			}
			$default_post_type = array();
			$postkey= array();
			$post_set=get_option('_iv_directory_url_postype' );
			if($post_set!=""){
				$default_fields=get_option('_iv_directory_url_postype' );
				}else{
				$default_fields['hotel']='Hotel';
				$default_fields['restaurant']='Restaurant';
				$default_fields['bar']='Bar';	
			}
			foreach($default_fields as $key => $value)
			{
				$postkey[] = $key;
			}
			$post_type = join("','",$postkey);
			$sql=$wpdb->prepare("SELECT count(*) as total FROM $wpdb->posts WHERE post_type IN ('%s' )  and post_author='%s' ", $post_type, $current_user->ID);
			$all_post = $wpdb->get_row($sql);
			$my_post_count=$all_post->total;
			if ( $my_post_count>=$max or !current_user_can('edit_posts') )  {
				$iv_redirect = get_option( '_iv_directories_profile_page');
				$reg_page= get_permalink( $iv_redirect);
			?>
			<?php esc_html_e('Please Upgrade Your Account','ivdirectories'); ?>
			<a href="<?php echo esc_url($reg_page).'?&profile=level'; ?>" title="Upgarde"><b><?php esc_html_e('Here','ivdirectories'); ?> </b></a>
			<?php esc_html_e('To Add More Post.','ivdirectories'); ?>
			<?php
				}else{
			?>
			<div class="row">
				<div class="col-md-12">
					<form action="" id="new_post" name="new_post"  method="POST" role="form">
						<div class=" form-group">
							<label for="text" class=" control-label"><?php esc_html_e('Listing Type','ivdirectories'); ?></label>
							<div class="">
								<?php
									$cpt = array();
									$cpt_set=get_option('_iv_directory_url_postype' );
									if($cpt_set!=""){
										$cpt=get_option('_iv_directory_url_postype' );
										}else{
										$cpt['hotel']='Hotel';
										$cpt['restaurant']='Restaurant';
										$cpt['bar']='Bar';	
									}
									$i=1;$old_select='';
									echo "<select id='cpt_page' name='cpt_page' class='form-control'>";
									foreach ( $cpt as $field_key => $field_value ) {
										echo "<option value='{$field_key}' ".($old_select==$field_key ? 'selected':'').">{$field_value}</option>";
									}
									echo "</select>";
								?>
							</div>
						</div>
						<div class=" form-group">
							<label for="text" class=" control-label"><?php esc_html_e('Name/Title','ivdirectories'); ?></label>
							<div class="  ">
								<input type="text" class="form-control-solid" name="title" id="title" value="" placeholder="<?php esc_html_e('Enter Name Here','ivdirectories'); ?>">
							</div>
						</div>
						<div class="form-group">
							<div class=" ">
								<?php
									$settings_a = array(
									'textarea_rows' =>8,
									'editor_class' => 'form-control-solid'
									);
									$editor_id = 'new_post_content';
									wp_editor( '', $editor_id,$settings_a );
								?>
							</div>
						</div>
						<div class=" row form-group ">
							<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Logo','ivdirectories'); ?>  </label>
							<div class="col-md-4" id="logo_image_div">
								<a  href="javascript:void(0);" onclick="logo_post_image('logo_image_div');"  >
									<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>
								</a>
							</div>
							<input type="hidden" name="logo_image_id" id="logo_image_id" value="">
							<div class="col-md-3" id="logo_image_edit">
								<button type="button" onclick="logo_post_image('logo_image_div');"  class="btn btn-xs green-haze"><?php esc_html_e('Add','ivdirectories'); ?> </button>
							</div>
						</div>
						<div class=" row form-group ">
							<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Feature Image','ivdirectories'); ?>  </label>
							<div class="col-md-4" id="post_image_div">
								<a  href="javascript:void(0);" onclick="edit_post_image('post_image_div');"  >
									<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>
								</a>
							</div>
							<input type="hidden" name="feature_image_id" id="feature_image_id" value="">
							<div class="col-md-3" id="post_image_edit">
								<button type="button" onclick="edit_post_image('post_image_div');"  class="btn btn-xs green-haze"><?php esc_html_e('Add','ivdirectories'); ?> </button>
							</div>
						</div>
						<div class=" row form-group ">
							<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Image Gallery','ivdirectories'); ?>
								<button type="button" onclick="edit_gallery_image('gallery_image_div');"  class="btn btn-xs green-haze"><?php esc_html_e('Add Images','ivdirectories'); ?></button>
							</label>
						</div>
						<div class=" row form-group ">
							<input type="hidden" name="gallery_image_ids" id="gallery_image_ids" value="">
							<div class="col-md-12" id="gallery_image_div">
							</div>
						</div>
						<div class="clearfix"></div>
						<div class=" row form-group ">
							<label for="text" class=" col-md-12 control-label"><?php esc_html_e('Post Status','ivdirectories'); ?>  </label>
							<div class="col-md-12" id="">
								<select name="post_status" id="post_status"  class="form-control-solid">
									<?php
										$dir_approve_publish =get_option('_dir_approve_publish');
										if($dir_approve_publish!='yes'){?>
										<option value="publish"><?php esc_html_e('Publish','ivdirectories'); ?></option>
										<?php
											}else{
											if(isset($current_user->roles[0]) and $current_user->roles[0]=='administrator'){?>
											<option value="publish"><?php esc_html_e('Publish','ivdirectories'); ?></option>
											<?php
											}
										?>
										<option value="pending"><?php esc_html_e('Pending Review','ivdirectories'); ?></option>
										<?php
										}
									?>
									<option value="draft"><?php esc_html_e('Draft','ivdirectories'); ?></option>
								</select>
							</div>
						</div>
						<div class="clearfix"></div>
						<div class=" row form-group">
							<label for="text" class=" col-md-12 control-label"><?php esc_html_e('Category','ivdirectories'); ?></label>
							<div class=" col-md-12 " id="select_cpt">
								<?php
									$selected='';
									foreach ( $cpt as $field_key => $field_value ) {
										echo '<select name="postcats[]" class="form-control-solid " multiple="multiple" size="8">';
										echo'	<option selected="'.esc_html($selected).'" value="">'.esc_html__('Choose a category','ivdirectories').'</option>';
										$selected='';
										if( isset($_POST['submit'])){
											$selected = $_POST['postcats'];
										}
										//directories
										$taxonomy = $field_key.'-category';
										$args = array(
										'orderby'           => 'name',
										'order'             => 'ASC',
										'hide_empty'        => false,
										'exclude'           => array(),
										'exclude_tree'      => array(),
										'include'           => array(),
										'number'            => '',
										'fields'            => 'all',
										'slug'              => '',
										'parent'            => '0',
										'hierarchical'      => true,
										'child_of'          => 0,
										'childless'         => false,
										'get'               => '',
										);
										$terms = get_terms($taxonomy,$args); // Get all terms of a taxonomy
										if ( $terms && !is_wp_error( $terms ) ) :
										$i=0;
										foreach ( $terms as $term_parent ) {  ?>
										<?php
											echo '<option  value="'.esc_html($term_parent->slug).'" '.($selected==$term_parent->slug?'selected':'' ).'><strong>'.esc_html($term_parent->name).'<strong></option>';
										?>
										<?php
											$args2 = array(
											'type'                     => $field_key,
											'parent'                   => $term_parent->term_id,
											'orderby'                  => 'name',
											'order'                    => 'ASC',
											'hide_empty'               => 0,
											'hierarchical'             => 1,
											'exclude'                  => '',
											'include'                  => '',
											'number'                   => '',
											'taxonomy'                 => $field_key.'-category',
											'pad_counts'               => false
											);
											$categories = get_categories( $args2 );
											if ( $categories && !is_wp_error( $categories ) ) :
											foreach ( $categories as $term ) {
												echo '<option  value="'.esc_html($term->slug).'" '.($selected==$term->slug?'selected':'' ).'>--'.esc_html($term->name).'</option>';
											}
											endif;
											$i++;
										}
										endif;
										echo '</select>';
										break;
									}
								?>
							</div>
						</div>
						<div class=" form-group row">
							<div class="col-md-6 ">
								<label for="text" class=" control-label  "><?php esc_html_e('Address','ivdirectories'); ?></label>
								<input type="text" class="form-control col-md-8 " name="address" id="address"  value="" placeholder="<?php esc_html_e('Enter address Here','ivdirectories'); ?>">
							</div>
							<div class=" col-md-6">
								<label for="text" class=" control-label"><?php esc_html_e('Area','ivdirectories'); ?></label>
								<input type="text" class="form-control col-md-8" name="area" id="area" value="" placeholder="<?php esc_html_e('Enter Area Here','ivdirectories'); ?>">
							</div>
						</div>
						<div class=" form-group row">
							<div class="col-md-6 ">
								<label for="text" class=" control-label "><?php esc_html_e('City','ivdirectories'); ?></label>
								<input type="text" class="form-control col-md-8" name="city" id="city" value="" placeholder="<?php esc_html_e('Enter city ','ivdirectories'); ?>">
							</div>
							<div class=" col-md-6">
								<label for="text" class=" control-label "><?php esc_html_e('Zipcode','ivdirectories'); ?></label>
								<input type="text" class="form-control col-md-8" name="postcode" id="postcode" value="" placeholder="<?php esc_html_e('Enter Zipcode ','ivdirectories'); ?>">
							</div>
						</div>
						<div class=" form-group row">
							<div class=" col-md-6">
								<label for="text" class=" control-label "><?php esc_html_e('State','ivdirectories'); ?></label>
								<input type="text" class="form-control col-md-8" name="state" id="state" value="" placeholder="<?php esc_html_e('Enter State ','ivdirectories'); ?>">
							</div>
							<div class=" col-md-6">
								<label for="text" class=" control-label "><?php esc_html_e('Country','ivdirectories'); ?></label>
								<input type="text" class="form-control col-md-8" name="country" id="country" value="" placeholder="<?php esc_html_e('Enter Country ','ivdirectories'); ?>">
							</div>
						</div>
						<div class=" form-group row">
							<div class=" col-md-6">
								<label for="text" class=" control-label "><?php esc_html_e('Latitude','ivdirectories'); ?></label>
								<input type="text" class="form-control col-md-8" name="latitude" id="latitude" value="" placeholder="<?php esc_html_e('Enter latitude ','ivdirectories'); ?>">
							</div>
							<div class=" col-md-6">
								<label for="text" class=" control-label "><?php esc_html_e('Longitude','ivdirectories'); ?></label>
								<input type="text" class="form-control col-md-8" name="longitude" id="longitude" value="" placeholder="<?php esc_html_e('Enter longitude ','ivdirectories'); ?>">
							</div>
						</div>
						<div class="clearfix">&nbsp;</div>
						<div class=" form-group">
							<label for="text" class=" control-label"><?php esc_html_e('Address Map','ivdirectories'); ?></label>
							<div  id="map-canvas"></div>
						</div>
						<div class="clearfix"></div>
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title col-lg-10">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseEight">
										<?php esc_html_e('Speciality(s)','ivdirectories'); ?>
									</a>
								</h4>
								<h4 class="panel-title">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseEight">
										<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
									</a>
								</h4>
							</div>
							<div id="collapseEight" class="panel-collapse collapse">
								<div class="panel-body">
									<div class=" form-group">
										<div class=" ">
											<?php
												$Specialities =esc_html__('Wheelchair access, Accept credit cards, Kids corner,Car parking,Pets friendly,Gift wrapping,Bike parking,Free Wi-Fi,Alcohol,Reservations,Street Parking,Breakfast and Meals,Chauffer Check-In,Pick Up/ Drop Off Service,Car parking,Luggage Forwarding Service,Pick Up/ Drop Off Service,Movie Library,Bar,Private Dining Hall,Rooftop Viewpoint,Tesla Supercharger,Locker Room,Hot tub,Fitness Centre','ivdirectories');
												$field_set=get_option('iv_listing_Specialities' );
												if($field_set!=""){
													$Specialities=get_option('iv_listing_Specialities' );
												}
												$i=1;
												$Specialities_fields= explode(",",$Specialities);
												foreach ( $Specialities_fields as $field_value ) { ?>
												<div class="col-md-4">
													<label class="form-group"> <input type="checkbox" name="Specialities_arr[]" id="Specialities_arr[]" value="<?php echo esc_html($field_value); ?>"> <?php echo esc_html($field_value); ?> </label>
												</div>
												<?php
												}
											?>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title col-lg-10">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseEight1">
										<?php esc_html_e('Amenities/Tags','ivdirectories'); ?>
									</a>
								</h4>
								<h4 class="panel-title">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseEight1">
										<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
									</a>
								</h4>
							</div>
							<div id="collapseEight1" class="panel-collapse collapse">
								<div class="panel-body">
									<div class=" form-group">
										
										<div id="iv_tags">
											<?php
												foreach ( $cpt as $field_key => $field_value ) {
													$args2 = array(
													'type'                     => $field_key,
													'orderby'                  => 'name',
													'order'                    => 'ASC',
													'hide_empty'               => 0,
													'hierarchical'             => 1,
													'exclude'                  => '',
													'include'                  => '',
													'number'                   => '',
													'taxonomy'                 => $field_key.'_tag',
													'pad_counts'               => false
													);
													$categories = get_categories( $args2 );
													if ( $categories && !is_wp_error( $categories ) ) :
													foreach ( $categories as $term ) {
													?>
													<div class="col-md-4">
														<label class="form-group"> <input type="checkbox" name="tag_arr[]" id="tag_arr[]" value="<?php echo esc_html($term->slug); ?>"> <?php echo esc_html($term->name); ?> </label>
													</div>
													<?php
													}
													endif;
													$i++;
													break;
												}
											?>
										</div>
									</div>
									<div class="clearfix"></div>
									<div class=" form-group">
										<label for="text" class=" control-label"><?php esc_html_e('Add New Amenities/Tags','ivdirectories'); ?></label>
										<div class="  ">
											<input type="text" class="form-control" name="new_tag" id="new_tag" value="" placeholder="<?php esc_html_e('Enter New Tags: Separate tags with commas','ivdirectories'); ?>">
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="clearfix"></div>
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title col-lg-10">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseFour">
										<?php esc_html_e('Contact Info','ivdirectories'); ?>
									</a>
								</h4>
								<h4 class="panel-title">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseFour">
										<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
									</a>
								</h4>
							</div>
							<div id="collapseFour" class="panel-collapse collapse">
								<div class="panel-body">
									<div class=" form-group">
										<label for="text" class=" control-label"><?php esc_html_e('Phone','ivdirectories'); ?></label>
										<div class="  ">
											<input type="text" class="form-control-solid" name="phone" id="phone" value="" placeholder="<?php esc_html_e('Enter Phone Number','ivdirectories'); ?>">
										</div>
									</div>
									<div class=" form-group">
										<label for="text" class=" control-label"><?php esc_html_e('Fax','ivdirectories'); ?></label>
										<div class="  ">
											<input type="text" class="form-control-solid" name="fax" id="fax" value="" placeholder="<?php esc_html_e('Enter Fax Number','ivdirectories'); ?>">
										</div>
									</div>
									<div class=" form-group">
										<label for="text" class=" control-label"><?php esc_html_e('Email Address','ivdirectories'); ?></label>
										<div class="  ">
											<input type="text" class="form-control-solid" name="contact-email" id="contact-email" value="" placeholder="<?php esc_html_e('Enter Email Address','ivdirectories'); ?>">
										</div>
									</div>
									<div class=" form-group">
										<label for="text" class=" control-label"><?php esc_html_e('Web Site','ivdirectories'); ?></label>
										<div class="  ">
											<input type="text" class="form-control-solid" name="contact_web" id="contact_web" value="" placeholder="<?php esc_html_e('Enter Web Site','ivdirectories'); ?>">
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="clearfix"></div>
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title col-lg-10">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapsethirty2">
										<?php esc_html_e('Awards','ivdirectories'); ?>
									</a>
								</h4>
								<h4 class="panel-title">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapsethirty2">
										<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
									</a>
								</h4>
							</div>
							<div id="collapsethirty2" class="panel-collapse collapse">
								<div class="panel-body">
									<?php
										// video, event ,  award
										if($this->check_write_access('award')){
										?>
										<div id="awards">
											<div id="award">
												<div class=" form-group">
													<label for="text" class=" control-label"><?php esc_html_e('Award Title','ivdirectories'); ?></label>
													<div class="  ">
														<input type="text" class="form-control-solid" name="award_title[]" id="award_title[]" value="" placeholder="<?php esc_html_e('Enter award title','ivdirectories'); ?>">
													</div>
												</div>
												<div class=" form-group">
													<label for="text" class=" control-label"><?php esc_html_e('Award Description','ivdirectories'); ?></label>
													<div class="  ">
														<input type="text" class="form-control-solid" name="award_description[]" id="award_description[]" value="" placeholder="<?php esc_html_e('Enter Award Description','ivdirectories'); ?>">
													</div>
												</div>
												<div class=" form-group">
													<label for="text" class=" control-label"><?php esc_html_e('Year(s) for which award was received','ivdirectories'); ?></label>
													<div class="  ">
														<input type="text" class="form-control-solid" name="award_year[]" id="award_year[]" value="" placeholder="<?php esc_html_e('Enter Award Year','ivdirectories'); ?>">
													</div>
												</div>
												<div class=" form-group mgt10">
													<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Award Image','ivdirectories'); ?>  </label>
													<div class="col-md-4" id="award_image_div">
														<a  href="javascript:void(0);" onclick="award_post_image(this);"  >
															<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>
														</a>
													</div>
												</div>
											</div>
										</div>
										<div class=" row  form-group ">
											<div class="col-md-12" >
												<button type="button" onclick="add_award_field();"  class="btn btn-xs green-haze"><?php esc_html_e('Add More','ivdirectories'); ?></button>
											</div>
										</div>
										<?php
											}else{
											esc_html_e('Please upgrade your account to add Award ','ivdirectories');
										}
									?>
								</div>
							</div>
						</div>
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title col-lg-10">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapsethirty21">
										<?php esc_html_e('Food Menu','ivdirectories'); ?>
									</a>
								</h4>
								<h4 class="panel-title">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapsethirty21">
										<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
									</a>
								</h4>
							</div>
							<div id="collapsethirty21" class="panel-collapse collapse">
								<div class="panel-body">
								
										<div id="menus">
											<div id="menu">
												<div class=" form-group">
													<label for="text" class=" control-label"><?php esc_html_e('Menu Title','ivdirectories'); ?></label>
													<div class="  ">
														<input type="text" class="form-control-solid" name="menu_title[]" id="menu_title[]" value="" placeholder="<?php esc_html_e('Enter menu title','ivdirectories'); ?>">
													</div>
												</div>
												<div class=" form-group">
													<label for="text" class=" control-label"><?php esc_html_e('Menu Description','ivdirectories'); ?></label>
													<div class="  ">
														<input type="text" class="form-control-solid" name="menu_description[]" id="menu_description[]" value="" placeholder="<?php esc_html_e('Enter menu Description','ivdirectories'); ?>">
													</div>
												</div>
												<div class=" form-group">
													<label for="text" class=" control-label"><?php esc_html_e('Price','ivdirectories'); ?></label>
													<div class="  ">
														<input type="text" class="form-control-solid" name="menu_price[]" id="menu_price[]" value="" placeholder="<?php esc_html_e('Enter Menu Price','ivdirectories'); ?>">
													</div>
												</div>
												<div class=" form-group">
													<label for="text" class=" control-label"><?php esc_html_e('Order Now Link','ivdirectories'); ?></label>
													<div class="  ">
														<input type="text" class="form-control-solid" name="menu_order[]" id="menu_order[]" value="" placeholder="<?php esc_html_e('Enter order full link','ivdirectories'); ?>">
													</div>
												</div>
												<div class=" form-group " style="margin-top:10px">
													<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Menu Image','ivdirectories'); ?>  </label>
													<div class="col-md-4" id="menu_image_div">
														<a  href="javascript:void(0);" onclick="menu_post_image(this);"  >
															<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>
														</a>
													</div>
												</div>
											</div>
										</div>
										<div class=" row  form-group ">
											<div class="col-md-12" >
												<button type="button" onclick="add_menu_field();"  class="btn btn-xs green-haze"><?php esc_html_e('Add More','ivdirectories'); ?></button>
											</div>
										</div>
										
								</div>
							</div>
						</div>
						<div class="clearfix"></div>
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title col-lg-10">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapsethirty22">
										<?php esc_html_e('Room','ivdirectories'); ?>
									</a>
								</h4>
								<h4 class="panel-title" >
									<a data-toggle="collapse" data-parent="#accordion" href="#collapsethirty22">
										<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
									</a>
								</h4>
							</div>
							<div id="collapsethirty22" class="panel-collapse collapse">
								<div class="panel-body">
									
										<div id="rooms">
											<div id="room">
												<div class=" form-group">
													<label for="text" class=" control-label"><?php esc_html_e('Room Title','ivdirectories'); ?></label>
													<div class="  ">
														<input type="text" class="form-control-solid" name="room_title[]" id="room_title[]" value="" placeholder="<?php esc_html_e('Enter Room Title','ivdirectories'); ?>">
													</div>
												</div>
												<div class=" form-group">
													<label for="text" class=" control-label"><?php esc_html_e('Room Description','ivdirectories'); ?></label>
													<div class="  ">
														<input type="text" class="form-control-solid" name="room_description[]" id="room_description[]" value="" placeholder="<?php esc_html_e('Enter Room Description','ivdirectories'); ?>">
													</div>
												</div>
												<div class=" form-group">
													<label for="text" class=" control-label"><?php esc_html_e('Price','ivdirectories'); ?></label>
													<div class="  ">
														<input type="text" class="form-control-solid" name="room_price[]" id="room_price[]" value="" placeholder="<?php esc_html_e('Enter Room Price','ivdirectories'); ?>">
													</div>
												</div>
												<div class=" form-group">
													<label for="text" class=" control-label"><?php esc_html_e('Order Now Link','ivdirectories'); ?></label>
													<div class="  ">
														<input type="text" class="form-control-solid" name="room_order[]" id="room_order[]" value="" placeholder="<?php esc_html_e('Enter order now full link','ivdirectories'); ?>">
													</div>
												</div>
												<div class=" form-group " style="margin-top:10px">
													<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Room Image','ivdirectories'); ?>  </label>
													<div class="col-md-4" id="room_image_div">
														<a  href="javascript:void(0);" onclick="room_post_image(this);"  >
															<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>
														</a>
													</div>
												</div>
											</div>
										</div>
										<div class=" row  form-group ">
											<div class="col-md-12" >
												<button type="button" onclick="add_room_field();"  class="btn btn-xs green-haze"><?php esc_html_e('Add More','ivdirectories'); ?></button>
											</div>
										</div>
										
								</div>
							</div>
						</div>
						<div class="clearfix"></div>
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title col-lg-10">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapse23">
										<?php esc_html_e('Booking Form','ivdirectories'); ?>
									</a>
								</h4>
								<h4 class="panel-title" >
									<a data-toggle="collapse" data-parent="#accordion" href="#collapse23">
										<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
									</a>
								</h4>
							</div>
							<div id="collapse23" class="panel-collapse collapse">
								<div class="panel-body">
									<?php
										// video, event , doctor , booking
										if($this->check_write_access('booking')){
										?>								
										<div class=" form-group">
											<div class="radio">
												<label>
													<input type="radio" name="override_bookingf" id="override_bookingf" value="no" checked>
													<?php esc_html_e('Default Booking Form','ivdirectories'); ?> 
												</label>
											</div>	
											<div class="radio">
												<label>
													<input type="radio" name="override_bookingf" id="override_bookingf" value="yes" >
													<?php esc_html_e('Add Shortcode','ivdirectories'); ?> 
												</label>
											</div>													
										</div>
										<div id="booking_sc" name="booking_sc"  class="displaynone">	  									
											<div class=" form-group" >
												<label for="text" class=" control-label"><?php esc_html_e('Shortcode','ivdirectories'); ?></label>						
												<div class="  "> 
													<input type="text" class="" name="booking_stcode" id="booking_stcode" value="" placeholder="<?php esc_html_e('Enter Booking Shortcode','ivdirectories'); ?>">
												</div>																
											</div>
										</div>		
										<?php
											}else{
											esc_html_e('Please upgrade your account to add Booking form ','ivdirectories');
										}
									?>
								</div>
							</div>
						</div>
						
						<div class="clearfix"></div>
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title col-lg-10 ">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseThree">
										<?php esc_html_e('Videos','ivdirectories'); ?>
									</a>
								</h4>
								<h4 class="panel-title">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseThree">
										<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
									</a>
								</h4>
							</div>
							<div id="collapseThree" class="panel-collapse collapse">
								<div class="panel-body">
									<?php
										// video, event , doctor , booking
										if($this->check_write_access('video')){
										?>
										<div class=" form-group">
											<label for="text" class=" control-label"><?php esc_html_e('Youtube','ivdirectories'); ?></label>
											<div class="  ">
												<input type="text" class="form-control-solid" name="youtube" id="youtube" value="" placeholder="<?php esc_html_e('Enter Youtube video ID, e.g : bU1QPtOZQZU ','ivdirectories'); ?>">
											</div>
										</div>
										<div class=" form-group">
											<label for="text" class=" control-label"><?php esc_html_e('vimeo','ivdirectories'); ?></label>
											<div class="  ">
												<input type="text" class="form-control-solid" name="vimeo" id="vimeo" value="" placeholder="<?php esc_html_e('Enter vimeo ID, e.g : 134173961','ivdirectories'); ?>">
											</div>
										</div>
										<?php
											}else{
											esc_html_e('Please upgrade your account to add video ','ivdirectories');
										}
									?>
								</div>
							</div>
						</div>
						<div class="clearfix"></div>
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title col-lg-10">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseFive">
										<?php esc_html_e('Social Profiles','ivdirectories'); ?>
									</a>
								</h4>
								<h4 class="panel-title">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseFive">
										<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
									</a>
								</h4>
							</div>
							<div id="collapseFive" class="panel-collapse collapse">
								<div class="panel-body">
									<div class="form-group">
										<label class="control-label"><?php esc_html_e('FaceBook', 'ivdirectories' ); ?></label>
										<input type="text" name="facebook" id="facebook" value="" class="form-control-solid"/>
									</div>
									<div class="form-group">
										<label class="control-label"><?php esc_html_e('Linkedin', 'ivdirectories' ); ?></label>
										<input type="text" name="linkedin" id="linkedin" value="" class="form-control-solid"/>
									</div>
									<div class="form-group">
										<label class="control-label"><?php esc_html_e('Twitter', 'ivdirectories' ); ?></label>
										<input type="text" name="twitter" id="twitter" value="" class="form-control-solid"/>
									</div>
									<div class="form-group">
										<label class="control-label"><?php esc_html_e('Google+', 'ivdirectories' ); ?> </label>
										<input type="text" name="gplus" id="gplus" value=""  class="form-control-solid"/>
									</div>
									<div class="form-group">
										<label class="control-label"><?php esc_html_e('Pinterest', 'ivdirectories' ); ?> </label>
										<input type="text" name="pinterest" id="pinterest" value=""  class="form-control-solid"/>
									</div>
									<div class="form-group">
										<label class="control-label"><?php esc_html_e('Instagram', 'ivdirectories' ); ?> </label>
										<input type="text" name="instagram" id="instagram" value=""  class="form-control-solid"/>
									</div>
								</div>
							</div>
						</div>
						<div class="clearfix"></div>
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title col-lg-10">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseTwo">
										<?php esc_html_e('Additional Info','ivdirectories'); ?>
									</a>
								</h4>
								<h4 class="panel-title">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseTwo">
										<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
									</a>
								</h4>
							</div>
							<div id="collapseTwo" class="panel-collapse collapse">
								<div class="panel-body">
									<?php
										$default_fields = array();
										$field_set=get_option('iv_directories_fields' );
										if($field_set!=""){
											$default_fields=get_option('iv_directories_fields' );
											}else{
											$default_fields['Rooms']='Rooms';
											$default_fields['suites']='Suites';
											$default_fields['Rating_stars']='Rating Stars';
											$default_fields['CHECK_IN']='Check In';
											$default_fields['CHECK_out']='Check Out';
											$default_fields['Cancellation']='Cancellation';
											$default_fields['Pets']='Pets';
											$default_fields['Children_and_Extra_Beds']='Children and Extra Beds';	
										}
										$i=1;
										foreach ( $default_fields as $field_key => $field_value ) { ?>
										<div class="form-group">
											<label class="control-label"><?php echo esc_html($field_value); ?></label>
											<input type="text" placeholder="" name="<?php echo esc_html($field_key);?>" id="<?php echo esc_html($field_key);?>"  class="form-control-solid" value=""/>
										</div>
										<?php
										}
									?>
								</div>
							</div>
						</div>
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title col-lg-10">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseOne">
										<?php esc_html_e('Working Time','ivdirectories'); ?>
									</a>
								</h4>
								<h4 class="panel-title">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseOne">
										<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
									</a>
								</h4>
							</div>
							<div id="collapseOne" class="panel-collapse collapse">
								<div class="panel-body">
									<div id="day_field_div">
										<div class=" row form-group " id="day-row1" >
											<div class=" col-md-4">
												<select name="day_name[]" id="day_name[]" class="form-control-solid">														
													<option value="<?php esc_html_e('Monday','ivdirectories'); ?> "> <?php esc_html_e('Monday','ivdirectories'); ?>  </option>
													<option value="<?php esc_html_e('Tuesday','ivdirectories'); ?>"><?php esc_html_e('Tuesday','ivdirectories'); ?></option>
													<option value="<?php esc_html_e('Wednesday','ivdirectories'); ?>"><?php esc_html_e('Wednesday','ivdirectories'); ?></option>
													<option value="<?php esc_html_e('Thursday','ivdirectories'); ?>"><?php esc_html_e('Thursday','ivdirectories'); ?></option>
													<option value="<?php esc_html_e('Friday','ivdirectories'); ?>"><?php esc_html_e('Friday','ivdirectories'); ?></option>
													<option value="<?php esc_html_e('Saturday','ivdirectories'); ?>"><?php esc_html_e('Saturday','ivdirectories'); ?></option>
													<option value="<?php esc_html_e('Sunday','ivdirectories'); ?>"><?php esc_html_e('Sunday','ivdirectories'); ?></option>
												</select>
											</div>
											<div  class=" col-md-4">
												<input type="text" placeholder="<?php esc_html_e('12:00 AM','ivdirectories'); ?> " name="day_value1[]" id="day_value1[]"  class="form-control" />
											</div>
											<div  class="col-md-4">
												<input type="text" placeholder="<?php esc_html_e('12:00 AM','ivdirectories'); ?> " name="day_value2[]" id="day_value2[]"  class="form-control" />
											</div>
										</div>
									</div>
									<div class=" row  form-group ">
										<div class="col-md-12" >
											<button type="button" onclick="add_day_field();"  class="btn btn-xs green-haze"><?php esc_html_e('Add More','ivdirectories'); ?></button>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="clearfix"></div>
						<div class="panel panel-default">
							<div class="panel-heading">
								<h4 class="panel-title col-lg-10">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseSix">
										<?php esc_html_e('Event','ivdirectories'); ?>
									</a>
								</h4>
								<h4 class="panel-title">
									<a data-toggle="collapse" data-parent="#accordion" href="#collapseSix">
										<?php esc_html_e('[ Edit ]','ivdirectories'); ?>
									</a>
								</h4>
							</div>
							<div id="collapseSix" class="panel-collapse collapse">
								<div class="panel-body">
									<?php
										// video, event , doctor , booking
										if($this->check_write_access('event')){
										?>
										<div class=" form-group">
											<label for="text" class=" control-label"><?php esc_html_e('Event Title','ivdirectories'); ?></label>
											<input type="text" class="form-control-solid" name="event-title" id="event-title" value="" placeholder="<?php esc_html_e('Enter Title Here','ivdirectories'); ?>">
										</div>
										<div class=" form-group">
											<label for="text" class=" control-label"><?php esc_html_e('Event Detail','ivdirectories'); ?></label>
											<?php
												$settings_a = array(
												'textarea_rows' =>10,
												'editor_class' => 'form-control-solid'
												);
												$content_client ='';
												$editor_id = 'event-detail';
											?>
											<textarea id="event-detail" name="event-detail"  rows="4" class="form-control-solid" >  </textarea>
										</div>
										<div class=" row form-group mgt10">
											<label for="text" class=" col-md-5 control-label"><?php esc_html_e('Event Image','ivdirectories'); ?>  </label>
											<div class="col-md-4" id="event_image_div">
												<a  href="javascript:void(0);" onclick="event_post_image('event_image_div');"  >
													<?php  echo '<img width="100px" src="'. wp_iv_directories_URLPATH.'assets/images/image-add-icon.png">'; ?>
												</a>
											</div>
											<input type="hidden" name="event_image_id" id="event_image_id" value="">
											<div class="col-md-3" id="event_image_edit">
												<button type="button" onclick="event_post_image('event_image_div');"  class="btn btn-xs green-haze"><?php esc_html_e('Add','ivdirectories'); ?></button>
											</div>
										</div>
										<?php
											}else{
											esc_html_e('Please upgrade your account to add event ','ivdirectories');
										}
									?>
								</div>
							</div>
						</div>
						<div class="margiv-top-10">
							<div class="" id="update_message"></div>
							<input type="hidden" name="user_post_id" id="user_post_id" value="">
							<button type="button" onclick="iv_save_post();"  class="btn green-haze"><?php esc_html_e('Save Post','ivdirectories'); ?></button>
						</div>
					</form>
				</div>
			</div>
			<?php
			} // for Role
		?>
	</div>
</div>
<!-- END PROFILE CONTENT -->
<?php
	$my_theme = wp_get_theme();
	$theme_name= strtolower($my_theme->get( 'Name' ));
	wp_enqueue_script('iv_directories-ar-script-27', wp_iv_directories_URLPATH . 'admin/files/js/add-edit-listing.js');
	wp_localize_script('iv_directories-ar-script-27', 'dirpro_data', array(
	'ajaxurl' 			=> admin_url( 'admin-ajax.php' ),
	'loading_image'		=> '<img src="'.wp_iv_directories_URLPATH.'admin/files/images/loader.gif">',
	'current_user_id'	=>get_current_user_id(),
	'image10'	=>esc_html__('image','ivdirectories'),
	'myaccount'=> wp_create_nonce("myaccount"),
	'permalink'=> get_permalink(),
	'wp_iv_directories_URLPATH'=> wp_iv_directories_URLPATH,
	'theme_name'				=> $theme_name,
	) );
	wp_enqueue_script('iv_directories-ar-map', wp_iv_directories_URLPATH . 'admin/files/js/add-edit-listing-map.js');
	wp_localize_script('iv_directories-ar-map', 'dirpro_map_data', array(
	'ajaxurl' 			=> admin_url( 'admin-ajax.php' ),
	'latitude' =>'',
	'longitude'=> '',		
	) );
?>